<?php
/*
	-------------------------------------------------
	EMAIL -> SMS 0.4 (29-SEP-2001)
	Keyvan Minoukadeh - keyvan@k1m.com
	http://www.k1m.com/php/
	-------------------------------------------------
	Script intended to be run every x minutes / hours (cron)
	to check a POP3 account for email and forward on to mobile
	using the free web-based service at http://www.mtnsms.com/.
	It can pick up subject lines of '+44987987987 sig'
	and will send to that number, alternatively if it does
	not contain a number it will send it to the admin mobile.

	The script itself isn't that complicated, pretty much all the
	work is done by the 2 classes...
	jm_sms 0.6 - http://james.mcglinn.org/jm_sms/ - by: James McGlinn
	POP3 - http://www.thewebmasters.net/php/POP3.phtml - by: CDI
	For more information see the source files of these 2 in the
	POP3 folder and the jm_sms folder

	* Read readme.txt for more information on how to use *

	-----------
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	-----------
*/

include("global.php");
include("pop3/class.POP3.php3");
include("kpop3.php");
include("jm_sms/class.jm_sms.php");

set_time_limit($time_limit);

// retreive config settings
// vars from config:
//   $process_email
//   $admin_mail_sent
//   $count
//   $prev_uidl_array
retrieve_config($config_file);

if (!$process_email) {
	$output("Email processing disabled");
	exit;
}

$count++;

update_config($config_file, array(
					'count'=>$count,
					'process_email'=>$process_email,
					'admin_mail_sent'=>$admin_mail_sent,
					'prev_uidl_array'=>$prev_uidl_array));

// terminate script if error count has exceeded the retries number
if ($count > $error_retries) {
	if (!$admin_mail_sent) {
		@mail($admin_email, "SMS Errors", "$count errors occured, maximum allowed was: $error_retries");
		$admin_mail_sent = 1;
	}
	update_config($config_file, array(
						'count'=>$count,
						'process_email'=>$process_email,
						'admin_mail_sent'=>$admin_mail_sent,
						'prev_uidl_array'=>$prev_uidl_array));
	$output("Maximum errors reached");
	exit;
}

$pop3 = new kPOP3();

if(!$pop3->connect($pop_server, 110))
{
	$output("Ooops $pop3->ERROR <BR>\n");
	exit;
}

$Count = $pop3->login($pop_login, $pop_pass);
if( ($Count == -1) )
{
	$output("<H1>Login Failed: $pop3->ERROR</H1>\n");
	exit;
}

if ($Count < 1)
{
	$output("Login OK: Inbox EMPTY<BR>\n");
	$pop3->quit();
	update_config($config_file, array(
						'count'=>0,
						'process_email'=>$process_email,
						'admin_mail_sent'=>$admin_mail_sent,
						'prev_uidl_array'=>array()));
	exit;
} else {
	$output("Login OK: Inbox contains [$Count] messages<BR>\n");
}

//--------------------------------------------------
//-- INITIALISE THE SMS CLASS
//--------------------------------------------------
$jm_sms = new jm_sms($sms_email, $sms_password, $sms_debug);

// Add additional accounts if required
if (count($sms_additional_login) > 0) {
	for ($x = 0; $x < count($sms_additional_login); $x++) {
		list($tmp_email, $tmp_pass) = $sms_additional_login[$x];
		$jm_sms->addLogin($tmp_email, $tmp_pass);
	}
}

srand((double)microtime() * 1000000);
$rand_key = array_rand($sms_server);
$jm_sms->setServer($sms_server[$rand_key]);

$output("Using: ". $jm_sms->getServer() ."<br>\n");
flush();

// grab unique ids of email messages
// $uidl_array[msg_number] = unique_id
// $uidl_array[0] = total_messages (we unset this)
$uidl_array = $pop3->uidl();
unset($uidl_array[0]);

// count number of email messages
$messages = $pop3->last();

// checks to see if number of messages waiting to be processed is greater than $sends_per_exec
// if it is it sets $sends_this_exec to $sends_per_exec
$sends_this_exec = (!empty($sends_per_exec) && $sends_per_exec < $messages) ? $sends_per_exec : $messages;

// message counter
$x = 1;

// send counter
// keeps track of how many messages
// have been sent by sms
$sent_msgs = 0;

flush();

// loop through email messages
while (($sent_msgs < $sends_this_exec) && $x <= $messages) {
	
	// if uidl for this message ($x) has already been
	// stored in array, if it has increment $x and continue
	// while loop (basically move on to next message)
	if (in_array($uidl_array[$x], $prev_uidl_array)) {
		$output("<br> - UIDL found in previous array (message $x has already been processed)\n");
		
		// if $leave_mail_on_server (found in config) is false then
		// mark email deleted (will not actually be deleted until pop3->quit()
		// has been executed
		if (!$leave_mail_on_server) {
			if(!$pop3->delete($x))
			{
				$output("oops $pop3->ERROR <BR>\n");
				$pop3->reset();
				exit;
			} else {
				$output("<br> - Message $x Deleted\n");
			}
		}
		
		flush();
		$x++;
		continue;
	}

	// grab header vars
	$fields_matched = $pop3->kfill_headers($x);

	// grab $body_lines of email body
	$sms_body = $pop3->kget_body($x, $body_lines);

	// cut and trim body
	$sms_body = substr(trim($sms_body), 0, 160); 

	// if $leave_mail_on_server (found in config) is false then
	// mark email deleted (will not actually be deleted until pop3->quit()
	// has been executed
	if (!$leave_mail_on_server) {
		if(!$pop3->delete($x))
		{
			$output("oops $pop3->ERROR <BR>\n");
			$pop3->reset();
			exit;
		} else {
			$output("<br> - Message $x Deleted\n");
		}
	}

	// tries to match a phone number in the subject line
	if (preg_match('/^(\+[0-9]+) ?([a-zA-Z0-9_-]+)?/', $pop3->subject, $matches) && $allow_forwarded_sms) {
		$signature = (isset($matches[2])) ? $matches[2] : $sms_glob_signature;
		$sms_success = $jm_sms->sendSMS($matches[1], $signature, $sms_body);
		unset($matches);

		if ($sms_success) {
			$output("<br> - Message $x Sent");
		} else {
			$output("<br> - <b>Message $x NOT Sent</b>");
		}

	} elseif (!empty($admin_mobile)) {
		$new_sms_body = "s: $pop3->subject\n";
		$new_sms_body .= "f: $pop3->from\n";
		$new_sms_body .= "m: $sms_body";
		$signature = "*";
		$sms_success = $jm_sms->sendSMS($admin_mobile, $signature, $new_sms_body);
		
		if ($sms_success) {
			$output("<br> - Message $x Sent");
		} else {
			$output("<br> - <b>Message $x NOT Sent</b>");
		}

	} else {
		$output("<br> - $pop3->subject didn't match");
	}

	// message process, so add current uidl
	// to $prev_uidl_array which will get
	// serialized and used on next run
	$prev_uidl_array[] = $uidl_array[$x];
	
	$x++;
	$sent_msgs++;

	flush();

} // loop

$pop3->quit();

// update $prev_uidl_array with only uidls which are present in
// the current uidl list AND the previous list (so basically
// removes the older uidls which have probably been downloaded)
// also it will not use all the existing ones because some of them
// might not have been processed yet..
$prev_uidl_array = array_intersect($prev_uidl_array, $uidl_array); 

// update config again
update_config($config_file, array(
					'count'=>0,
					'process_email'=>$process_email,
					'admin_mail_sent'=>$admin_mail_sent,
					'prev_uidl_array'=>$prev_uidl_array));

$output("<br><br>Done...\n");

?>
